## generate the text in cells (the Point estimate with 95% credible Interval)
.pe_text_conversion_u <- function(point_estimate, lower_bound, upper_bound, p_value, symbol_indicator){
  if(is.na(point_estimate) | point_estimate=="NA" ){
    return(NA)
  }else{
    point_estimate <- as.numeric(point_estimate)
    if(is.na(p_value)){
      temp_text <- paste0(sprintf("%.2f", point_estimate))
      if(!is.na(symbol_indicator)){
        temp_text <- paste0(temp_text, "<sup>", symbol_indicator, "</sup>")
      }
      return(temp_text)
    }else{
      if(p_value < 0.05){
        temp_text <- paste0("<b>", sprintf("%.2f", point_estimate), "<sup>", symbol_indicator, "</sup>", "</b>")
      }else{
        temp_text <- paste0(sprintf("%.2f", point_estimate))
        if(!is.na(symbol_indicator)){
          temp_text <- paste0(temp_text, "<sup>", symbol_indicator, "</sup>")
        }
      }
      return(temp_text)
    }
  }
}


.pe_text_conversion_l <- function(point_estimate, lower_bound, upper_bound, p_value, symbol_indicator){
  if(is.na(point_estimate)  | point_estimate=="NA"){
    return(NA)
  }else{
    lower_bound <- as.numeric(lower_bound)
    upper_bound <- as.numeric(upper_bound)
    if(is.na(p_value)){
      temp_text <- paste0("(", sprintf("%.2f", lower_bound), ",", sprintf("%.2f", upper_bound), ")")
      return(temp_text)
    }else{
      if(p_value < 0.05){
        temp_text <- paste0("<b>(", sprintf("%.2f", lower_bound), ",", sprintf("%.2f", upper_bound), ")</b>")
      }else{
        temp_text <- paste0("(", sprintf("%.2f", lower_bound), ",", sprintf("%.2f", upper_bound), ")")
      }
      return(temp_text)
    }
  }
}
