% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nparACT_flex_loop.R
\name{nparACT_flex_loop}
\alias{nparACT_flex_loop}
\title{Compute non-parametric actigraphy measures with a flexible low-activity window
for multiple files}
\usage{
nparACT_flex_loop(path, SR, cutoff = 1, minutes, plot = T, fulldays = T)
}
\arguments{
\item{path}{Character string specifying the path to a directory
containing the actigraphy files to be analysed.}

\item{SR}{Numeric. Sampling rate in Hertz (samples per second).}

\item{cutoff}{Numeric. Activity threshold used to classify movement.
Defaults to 1.}

\item{minutes}{Numeric. Length of the flexible low-activity window
(Lflex) in minutes.}

\item{plot}{Logical. If \code{TRUE}, group-level diagnostic plots
of hourly activity profiles are generated. Defaults to \code{TRUE}.}

\item{fulldays}{Logical. If \code{TRUE}, data are truncated to include
only complete 24-hour periods. Defaults to \code{TRUE}.}
}
\value{
A data frame with one row per processed file and the following columns:
\describe{
\item{IS}{Interdaily stability}
\item{IV}{Intradaily variability}
\item{RA}{Relative amplitude}
\item{L5}{Mean activity during the least active 5-hour period}
\item{L5_starttime}{Start time of the L5 period}
\item{M10}{Mean activity during the most active 10-hour period}
\item{M10_starttime}{Start time of the M10 period}
\item{Lflex}{Mean activity during the least active flexible period}
\item{Lflex_starttime}{Start time of the Lflex period}
}
}
\description{
Computes the classic non-parametric actigraphy measures
interdaily stability (IS), intradaily variability (IV),
and relative amplitude (RA), as well as the L5 and M10 values
and their respective start times. In addition, the function
computes a flexible low-activity period (Lflex) of user-defined
duration and its start time, looping over all actigraphy files
contained in a specified directory.
}
\details{
Each file in the directory is processed independently using
the same parameters. Results are returned as one row per file.

Files in \code{path} are expected to be plain text or CSV files
with either two columns (time, activity) or three columns
(date, time, activity). Time variables are internally converted
to \code{POSIXct}. Missing values in the activity signal are not
permitted.

Interdaily stability (IS) and intradaily variability (IV) are computed
from hourly averaged activity data. Relative amplitude (RA) is derived
from the difference between the most active 10-hour period (M10) and
the least active 5-hour period (L5). The flexible low-activity measure
(Lflex) represents the least active contiguous period of the duration
specified by \code{minutes}.

If \code{plot = TRUE}, an aggregated (grand average) hourly activity
profile across all files is generated.
}
