% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_borough_population.R
\name{nyc_borough_population}
\alias{nyc_borough_population}
\title{New York City Population by Borough, 1950 - 2040}
\source{
NYC Open Data: <https://data.cityofnewyork.us/City-Government/New-York-City-Population-by-Borough-1940-2040/xywu-7bv9>
}
\usage{
nyc_borough_population(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing City Record Online data.
}
\description{
Downloads historical and projected NYC population data by borough from NYC Open Data.
}
\details{
This dataset contains population figures for New York City's five boroughs
from 1940 to 2040. It includes both historical census data and population
projections, allowing analysis of demographic trends across Brooklyn, Bronx,
Manhattan, Queens, and Staten Island over a 90-year period.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_borough_population(limit = 2)
  small_sample

  nyc_borough_population(limit = 2, filters = list(borough = "Bronx"))
}
}
