% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_for_hire_vehicles.R
\name{nyc_for_hire_vehicles}
\alias{nyc_for_hire_vehicles}
\title{NYC For-Hire Vehicles (FHV) - Active}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/8wbx-tsch>
}
\usage{
nyc_for_hire_vehicles(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing For-Hire Vehicles (FHV) - Active data.
}
\description{
Downloads For-Hire Vehicles (FHV) - Active data from NYC Open Data.
}
\details{
This dataset includes all active For-Hire Vehicle (FHV) licenses in NYC,
such as taxis, limousines, and app-based services (e.g., Uber, Lyft).
Maintained by the NYC Taxi and Limousine Commission (TLC).
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_for_hire_vehicles(limit = 2)
  small_sample

  nyc_for_hire_vehicles(limit = 2, filters = list(active = "YES"))
}
}
