% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_ll97_shelter_pets.R
\name{nyc_locallaw97_shelter_pets}
\alias{nyc_locallaw97_shelter_pets}
\title{Local Law 97 of 2021 - Pets in Shelter Report}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Social-Services/Local-Law-97-of-2021-Pets-in-Shelter-Report/5nux-zfmw/about_data>
}
\usage{
nyc_locallaw97_shelter_pets(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Local Law 97 of 2021 - Pets in Shelter Report data.
}
\description{
Downloads Local Law 97 of 2021 - Pets in Shelter Report data from NYC Open Data.
}
\details{
This dataset contains quarterly survey response data on the types of pets whose
owners entered New York City homeless shelters. Each row represents combined
survey responses for one fiscal year quarter, which can be used by researchers
to examine trends in pet ownership among shelter entrants and inform policy or
resource planning.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_locallaw97_shelter_pets(limit = 2)
  small_sample

  nyc_locallaw97_shelter_pets(limit = 2, filters = list(date_quarter = "Qtr 1"))
}
}
