# DOWNLOAD
#' @include AllGenerics.R
NULL

#' @rdname hal_download
#' @export
hal_download.HALQuery <- function(query, destination,
                                  limit = 30, start = 0,
                                  progress = getOption("odyssey.progress"),
                                  verbose = getOption("odyssey.verbose"), ...) {
  ## Set parameters
  query$rows <- min(limit, 10000, na.rm = TRUE)
  query$fl <- "halId_s,files_s,version_i"

  ## Build request
  req <- hal_request(query, path = "search", instance = NULL)

  ## Progress bar
  if (progress) req <- httr2::req_progress(req)

  ## Search
  resp <- httr2::req_perform(req, path = NULL, verbosity = NULL)
  body <- httr2::resp_body_json(resp)$response

  files <- lapply(X = body$docs, FUN = getElement, name = "files_s")
  files <- files[!vapply(X = files, FUN = is.null, FUN.VALUE = logical(1))]

  if (verbose) {
    n_docs <- body$numFound
    n_files <- length(files)
    msg <- "%d notices out of %d (over %d found) include a downloadable file."
    message(sprintf(msg, n_files, limit, n_docs))
  }

  if (!dir.exists(destination)) dir.create(destination, recursive = FALSE)

  docs <- vapply(
    X = unlist(files, recursive = TRUE),
    FUN = function(x) {
      dest <- file.path(destination, basename(x))
      withCallingHandlers(
        tryCatch(
          utils::download.file(x, destfile = dest, quiet = T),
          error = function(e) return(1L)
        ),
        warning = function(w) {
          warning(conditionMessage(w), call. = FALSE)
          invokeRestart("muffleWarning")
        }
      )
    },
    FUN.VALUE = integer(1)
  )

  if (verbose && any(docs != 0)) {
    message(sprintf("%d files failed to download.", sum(docs != 0)))
  }

  invisible(destination)
}
