% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_hub.R
\name{search_hub}
\alias{search_hub}
\title{Search vbdhub.org}
\usage{
search_hub(
  query = "",
  db = c("vt", "vd", "gbif", "px"),
  fromdate = NULL,
  todate = NULL,
  locationpoly = NULL,
  taxonomy = NULL,
  exact = FALSE,
  withoutpublished = TRUE,
  returnlist = FALSE,
  simplify = TRUE,
  connections = 8
)
}
\arguments{
\item{query}{a search string.}

\item{db}{the databases to search.}

\item{fromdate}{the date from which to search (ISO format: yyyy-mm-dd).}

\item{todate}{the date up to which to search (ISO format: yyyy-mm-dd).}

\item{locationpoly}{a polygon or set of polygons in \code{terra::SpatVector} or WKT MULTIPOLYGON format within which to search. Easily generated using \code{\link[=match_countries]{match_countries()}}}

\item{taxonomy}{a numeric vector containing the gbif ids of taxa to search for (found using \code{\link[=match_species]{match_species()}} or similar functions).}

\item{exact}{whether to return exact matches only.}

\item{withoutpublished}{whether to return results without a publishing date when filtering by date.}

\item{returnlist}{return the raw output list rather than a formatted dataframe.}

\item{simplify}{if only a single database was searched, return an \code{ohvbd.ids} object instead (defaults to \code{TRUE}).}

\item{connections}{the number of connections to use to parallelise queries.}
}
\value{
an \code{ohvbd.hub.search} dataframe, an \code{ohvbd.ids} vector (if \code{returnlist=TRUE} and \code{length(db) == 1}) a list (if \code{returnlist=TRUE}) containing the search results.
}
\description{
Retrieve the IDs for any datasets matching the given search parameters.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
search_hub("Ixodes ricinus")
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{hub}
