% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vb_basereq.R
\name{vb_basereq}
\alias{vb_basereq}
\title{Generate a base request object for the vectorbyte databases}
\usage{
vb_basereq(
  baseurl = "https://vectorbyte.crc.nd.edu/portal/api/",
  useragent = "ROHVBD",
  unsafe = FALSE,
  .qa = FALSE
)
}
\arguments{
\item{baseurl}{the base url for the vectorbyte API.}

\item{useragent}{the user agent string used when contacting vectorbyte.}

\item{unsafe}{disable ssl verification (shouldn't ever be required unless you are otherwise experiencing SSL issues!)}

\item{.qa}{switch to the vb qa server (only useful for testing).}
}
\value{
Returns an httr2 request object, pointing at baseurl using useragent.
}
\description{
This request is used as the basis for all calls to the vectorbyte API.
It does not contain any tokens or session ids, and thus can be regenerated at any time.
}
\examples{
basereq <- vb_basereq(
  baseurl="https://vectorbyte.crc.nd.edu/portal/api/",
  useragent="ROHVBD")

}
\author{
Francis Windram
}
\concept{basereq}
