% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_datasets.R
\name{list_datasets}
\alias{list_datasets}
\title{List available ESM datasets from openESM repository}
\usage{
list_datasets(cache_hours = 24, metadata_version = "latest", max_attempts = 15)
}
\arguments{
\item{cache_hours}{Numeric. Number of hours to consider the cached dataset
index valid. Default is 24. Set to 0 to force fresh download.}

\item{metadata_version}{Character string specifying the metadata catalog version.
Default is "latest" which downloads the most recent version.}

\item{max_attempts}{Integer, maximum number of retry attempts for Zenodo API calls. Default is 15.}
}
\value{
A tibble with one row per dataset containing:
\itemize{
\item \code{dataset_id}: Character string with unique dataset identifier
\item \code{first_author}: Character string with first author's surname
\item \code{year}: Numeric year of publication
\item \code{reference_a}: Character string with primary reference
\item \code{reference_b}: Character string with secondary reference (if available)
\item \code{paper_doi}: Character string with publication DOI
\item \code{zenodo_doi}: Character string with Zenodo dataset DOI
\item \code{license}: Character string with dataset license
\item \code{link_to_data}: Character string with direct data link
\item \code{link_to_codebook}: Character string with codebook link
\item \code{link_to_code}: Character string with analysis code link
\item \code{n_participants}: Numeric number of participants
\item \code{n_time_points}: Numeric number of time points
\item \code{n_beeps_per_day}: Character string with beeps per day information
\item \code{passive_data_available}: Character string indicating passive data availability
\item \code{cross_sectional_available}: Character string indicating cross-sectional data availability
\item \code{topics}: Character string with study topics
\item \code{implicit_missingness}: Character string with missingness information
\item \code{raw_time_stamp}: Character string with timestamp format information
\item \code{sampling_scheme}: Character string with sampling scheme details
\item \code{participants}: Character string with participant information
\item \code{coding_file}: Character string with coding file information
\item \code{additional_comments}: Character string with additional notes
\item \code{features}: List column containing feature tibbles for each dataset
}
}
\description{
Retrieves a list of available Experience Sampling Method (ESM) datasets from
the openESM metadata repository. Returns a tibble with
dataset information and metadata that can be used with \code{\link[=get_dataset]{get_dataset()}}.
}
\details{
This function downloads and caches a master index of available datasets from
the openESM metadata repository, which is hosted on Zenodo.
The index is cached locally to avoid repeated downloads.
Use \code{cache_hours = 0} to force a fresh download of the index.

The returned tibble can be filtered and explored to identify datasets of
interest before downloading with \code{\link[=get_dataset]{get_dataset()}}.
}
\examples{
\donttest{
# List all available datasets
datasets <- list_datasets()

# Force fresh download of index
fresh_list <- list_datasets(cache_hours = 0)

# Use specific metadata version
datasets_v1 <- list_datasets(metadata_version = "1.0.0")

# Use dataset IDs with get_dataset()
dataset <- get_dataset(datasets$dataset_id[1])

\dontshow{
# cleanup
clear_cache(force = TRUE)
}

}

}
\seealso{
\code{\link[=get_dataset]{get_dataset()}} to download specific datasets
}
