% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNu.R
\name{getNu}
\alias{getNu}
\title{Calculate Nu}
\usage{
getNu(alpha, conditionalPower)
}
\arguments{
\item{alpha}{The (conditional) type I error rate of the design. Must be a numeric vector with values between 0 and 1.}

\item{conditionalPower}{The target conditional power \eqn{CP} of the design. Must be a numeric value.}
}
\value{
Factor linking information and \eqn{\alpha_2}.
}
\description{
Calculate the factor which relates \eqn{\alpha_2} to the second-stage information for given conditional power.
}
\details{
Note that this function uses factor 1 instead of factor 2 (Brannath & Bauer 2004). This has no impact on the optimal conditional error function, as constant factors are absorbed by the level constant \eqn{c_0}. \cr
The calculation is:
\deqn{\nu(\alpha_2(p_1)) = (\Phi^{-1}(1-\alpha_2(p_1)) + \Phi^{-1}(CP))^2.}
}
\examples{
getNu(alpha = 0.05, conditionalPower = 0.9)

# Returns 0 if alpha exceeds conditionalPower
getNu(alpha = 0.8, conditionalPower = 0.7)

}
\references{
Brannath, W. & Bauer, P. (2004). Optimal conditional error functions for the control of conditional power. Biometrics. https://www.jstor.org/stable/3695393
}
