% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.optweight.R
\name{plot.optweight}
\alias{plot.optweight}
\alias{plot.optweightMV}
\alias{plot.optweight.svy}
\title{Plot Dual Variables for Covariate Constraints}
\usage{
\method{plot}{optweight}(x, type = "variables", ...)

\method{plot}{optweightMV}(x, which.treat = 1L, type = "variables", ...)

\method{plot}{optweight.svy}(x, type = "variables", ...)
}
\arguments{
\item{x}{an \code{optweight}, \code{optweightMV}, or \code{optweight.svy} object; the output of a call to \code{\link[=optweight]{optweight()}}, \code{\link[=optweightMV]{optweightMV()}}, or \code{\link[=optweight.svy]{optweight.svy()}}.}

\item{type}{the type of plot to display; allowable options include \code{"variables"} (the default), which produces a row for each covariate, and \code{"constraints"}, which produces a row for each type of constraint (computed as the sum of the absolute dual variables for each constraint type).}

\item{\dots}{ignored.}

\item{which.treat}{for \code{optweightMV} objects, an integer corresponding to which treatment to display. Only one may be displayed at a time.}
}
\value{
A \code{ggplot} object that can be used with other \pkg{ggplot2} functions.
}
\description{
Plots the dual variables resulting from \code{\link[=optweight]{optweight()}}, \code{\link[=optweightMV]{optweightMV()}}, or \code{\link[=optweight.svy]{optweight.svy()}} in a way similar to figure 2 of Zubizarreta (2015), which explains how to interpret these values.
}
\details{
Dual variables represent the cost of changing the constraint on the objective function minimized to estimate the weights. For covariates with large values of the dual variable, tightening the constraint will increase the variability of the weights, and relaxing the constraint will decrease the variability of the weights, both to a greater extent than would doing the same for covariate with small values of the dual variable. See \code{\link[=optweight]{optweight()}} and \code{vignette("optweight")} for more information on interpreting dual variables.
}
\examples{
\dontshow{if (rlang::is_installed("cobalt")) withAutoprint(\{ # examplesIf}
library("cobalt")
data("lalonde", package = "cobalt")

tols <- process_tols(treat ~ age + educ + married +
                       nodegree + re74, data = lalonde,
                     tols = .1)

#Balancing covariates between treatment groups (binary)
ow1 <- optweight(treat ~ age + educ + married +
                   nodegree + re74, data = lalonde,
                 tols = tols,
                 estimand = "ATT")

# Note the L2 divergence and effective sample
# size (ESS)
summary(ow1, weight.range = FALSE)

# age has a low value, married is high
plot(ow1)

tols["age"] <- 0
ow2 <- optweight(treat ~ age + educ + married +
                   nodegree + re74, data = lalonde,
                 tols = tols,
                 estimand = "ATT")

# Notice that tightening the constraint on age has
# a negligible effect on the variability of the
# weights and ESS
summary(ow2, weight.range = FALSE)

tols["age"] <- .1
tols["married"] <- 0
ow3 <- optweight(treat ~ age + educ + married +
                   nodegree + re74, data = lalonde,
                 tols = tols,
                 estimand = "ATT")

# In contrast, tightening the constraint on married
# has a large effect on the variability of the
# weights, shrinking the ESS
summary(ow3, weight.range = FALSE)

# More duals are displayed when targeting other
# estimands:
ow4 <- optweight(treat ~ age + educ + married +
                   nodegree + re74, data = lalonde,
                 estimand = "ATE")

plot(ow4)

# Display duals by constraint type
plot(ow4, type = "constraints")
\dontshow{\}) # examplesIf}
}
\references{
Zubizarreta, J. R. (2015). Stable Weights that Balance Covariates for Estimation With Incomplete Outcome Data. \emph{Journal of the American Statistical Association}, 110(511), 910–922. \doi{10.1080/01621459.2015.1023805}
}
\seealso{
\code{\link[=optweight]{optweight()}}, \code{\link[=optweightMV]{optweightMV()}}, or \code{\link[=optweight.svy]{optweight.svy()}} to estimate the weights and the dual variables.

\code{\link[=plot.summary.optweight]{plot.summary.optweight()}} for plots of the distribution of weights.
}
