% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcidtr-package.R
\docType{package}
\name{orcidtr-package}
\alias{orcidtr-package}
\alias{orcidtr}
\title{orcidtr: Retrieve Data from the ORCID Public API}
\description{
Provides functions to retrieve public data from ORCID (Open Researcher and Contributor ID) records via the ORCID public API. Fetches employment history, education, works (publications, datasets, preprints), funding, peer review activities, and other public information. Returns data as structured data.table objects for easy analysis and manipulation. Replaces the discontinued 'rorcid' package with a modern, CRAN-compliant implementation.

The orcidtr package provides a modern, CRAN-compliant interface to the ORCID
public API. It allows you to retrieve employment history, education records,
publications, funding information, and peer review activities from ORCID
researcher profiles.
}
\section{Main Functions}{

\itemize{
\item \code{orcid_employments()}: Fetch employment history
\item \code{orcid_educations()}: Fetch education records
\item \code{orcid_works()}: Fetch publications and works
\item \code{orcid_funding()}: Fetch funding records
\item \code{orcid_peer_reviews()}: Fetch peer review activities
\item \code{orcid_fetch_record()}: Fetch complete ORCID record
\item \code{orcid_fetch_many()}: Batch fetch for multiple ORCIDs
}
}

\section{Authentication}{

Most public data is accessible without authentication. To use an optional
API token, set the \code{ORCID_TOKEN} environment variable:

\code{Sys.setenv(ORCID_TOKEN = "your-token-here")}
}

\section{Package Design}{

\itemize{
\item Uses native pipe (\verb{|>}) operator
\item Returns data.table objects
\item Fully qualified function calls (no library imports in functions)
\item No side effects or global state modifications
\item Graceful error handling
\item CRAN-compliant
}
}

\examples{
\dontrun{
# Fetch works for an ORCID
works <- orcid_works("0000-0002-1825-0097")

# Fetch complete record
record <- orcid_fetch_record("0000-0002-1825-0097")

# Batch fetch works for multiple ORCIDs
orcids <- c("0000-0002-1825-0097", "0000-0003-1419-2405")
all_works <- orcid_fetch_many(orcids, section = "works")
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/lorenzoFabbri/orcidtr}
  \item Report bugs at \url{https://github.com/lorenzoFabbri/orcidtr/issues}
}

}
\author{
\strong{Maintainer}: Lorenzo Fabbri \email{lorenzo.fabbri92sm@gmail.com}

}
\keyword{internal}
