% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin.R
\name{orderly_plugin_add_metadata}
\alias{orderly_plugin_add_metadata}
\title{Add metadata from plugin}
\usage{
orderly_plugin_add_metadata(name, field, data)
}
\arguments{
\item{name}{The name of the plugin; must be the same as used in
\code{\link[=orderly_plugin_register]{orderly_plugin_register()}} and
\code{\link[=orderly_plugin_context]{orderly_plugin_context()}}}

\item{field}{The name of a field to add the data to. This is
required even if your plugin only produces one sort of data, in
which case you can remove it later on within your serialisation
function.}

\item{data}{Arbitrary data to be added to the currently running
packet}
}
\value{
Nothing, called only for its side effects
}
\description{
Add plugin-specific metadata to a running packet. This will take
some describing. You accumulate any number of bits of metadata
into arbitrary fields, and then later on serialise these to json.
}
\examples{
# The example code from vignette("plugins") is available in the package
fs::dir_tree(system.file("examples/example.db", package = "orderly"))

# See orderly_plugin_add_metadata in context here:
orderly_example_show("R/plugin.R", example = "example.db")
}
