% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_linear.R
\name{log_linear_append_column}
\alias{log_linear_append_column}
\title{Appends a column to an existing design matrix.}
\usage{
log_linear_append_column(x, x_new, position = ncol(x) + 1)
}
\arguments{
\item{x}{the original design matrix}

\item{x_new}{the column to be appended}

\item{position}{column index within the new matrix for the new column.
Defaults to last position = appending the column}
}
\value{
the new design matrix
}
\description{
Takes the design matrix provided and appends the new column
}
\examples{
x <- log_linear_main_effect_design(vision_data)
new_column <- c(1, 0, 0, 0,
                0, 1, 0, 0,
                0, 0, 1, 0,
                0, 0, 0, 1)
x_prime <- log_linear_append_column(x, new_column)
}
