create_n <- function() {
  n <- matrix(c(17, 8, 4,
                6, 19, 3,
                3, 6, 9), nrow=3, byrow=TRUE)
  n
}


test_that("observed matrix is correct",{
  n <- create_n()
  expected_N <- 75
  expect_equal(sum(n), expected_N)
  expectedRowSums <- c(29, 28, 18)
  expect_equal(rowSums(n), expectedRowSums)
  expectedColSums <- c(26, 33, 16)
  expect_equal(colSums(n), expectedColSums)
})


test_that("kappa works", {
  n <- create_n()
  expected_kappa <- 0.3850779
  actual_kappa <- kappa(n)$kappa
  expect_true(abs(expected_kappa - actual_kappa) <= 0.0000005,
              info=paste(expected_kappa, actual_kappa))
}
)


test_that("weighted kappa works", {
  n <- create_n()
  # linear weights
  w <- matrix(c(0, 0.5, 1,
                0.5, 0, 0.5,
                1, 0.5, 0), nrow=3, byrow=TRUE)
  expected_kappa <- 0.396
  actual_kappa <- weighted_kappa(n, w)$kappa
  expect_true(abs(expected_kappa - actual_kappa) <= 0.0005,
              info=paste(expected_kappa, actual_kappa))

  #quadratic weights
  w1 <- matrix(c(0, 0.25, 1,
                0.25, 0, 0.25,
                1, 0.25, 0), nrow=3, byrow=TRUE)
  expected_kappa <- 0.4074361
  actual_kappa <- weighted_kappa(n, w1)$kappa
  expect_true(abs(expected_kappa - actual_kappa) <= 0.0000005,
              info=paste(expected_kappa, actual_kappa))
}
)


test_that("quadratic weighting works", {
  n <- create_n()

  #quadratic weighting
  expected_kappa <- 0.4074361
  actual_kappa <- weighted_kappa(n, quadratic=TRUE)$kappa
  expect_true(abs(expected_kappa - actual_kappa) <= 0.0000005,
              info=paste(expected_kappa, actual_kappa))
}
)


test_that("se is correct", {
  n <- matrix(c(16, 4, 3,
                6, 10, 0,
                2, 1, 8), nrow=3, byrow=TRUE)
  expected_N <- 50
  expect_equal(sum(n), expected_N)
  expectedRowSums <- c(23, 16, 11)
  expect_equal(rowSums(n), expectedRowSums)
  expectedColSums <- c(24, 15, 11)
  expect_equal(colSums(n), expectedColSums)

  expected_kappa <- 0.50
  expected_se <- 0.11
  result <- kappa(n)
  expect_true(abs(result$kappa - expected_kappa) <= 0.005)
  expect_true(abs(result$se - expected_se) <= 0.01,
              info=paste("se", expected_se, result$se))
}
)


test_that("depression data is correct", {
  expected_kappa <- 0.375
  result <- kappa(depression)
  actual_kappa <- result$kappa
  actual_se <- result$se
  expect_true(abs(expected_kappa - actual_kappa) <= 0.0005,
              info=paste("kappa", expected_kappa, actual_kappa))
  # se given in text is wrong
  # expected_se <- 0.079
  expected_se <- 0.0630226
  expect_true(abs(actual_se - expected_se) <= 0.0005,
              info=paste("se", expected_se, actual_se))

  expected_weighted_kappa <- 0.402
  w <- matrix(c(0.0, 0.5, 1.0,
                0.5, 0.0, 0.5,
                1.0, 0.5, 0.0), nrow=3, byrow=TRUE)
  result2 <- weighted_kappa(depression, w)
  actual_weighted_kappa <- result2$kappa
  expect_true(abs(expected_kappa - actual_kappa) <= 0.0005,
              info=paste(expected_kappa, actual_kappa))
  expected_se <- -1.0
}
)


test_that("weighted example in Fleiss et al (1969) is correct", {
  N <- 200
  w <- matrix(c(1.0, 0.0, 0.4444,
               0.0, 1.0, 0.6667,
               0.4444, 0.6667, 1.0), nrow=3, byrow=TRUE)
  p <- matrix(c(0.53, 0.05, 0.02,
                0.11, 0.14, 0.05,
                0.01, 0.06, 0.03), nrow=3, byrow=TRUE)
  n <- p * N
  result <- var_weighted_kappa(n, w)

  expect_true(abs(result$var_kappa - 0.003239) <= 0.00005,
              info=paste("kappa weighted non-null",
                         0.003239, result$var_kappa))

  expect_true(abs(result$var_kappa0 - 0.004270) <= 0.000005,
              info=paste("kappa weighted null",
                         0.00427, result$var_kappa0))
}
)


test_that("unnweighted example in Fleiss et al (1969) is correct", {
  N <- 200
  p <- matrix(c(0.53, 0.05, 0.02,
                0.11, 0.14, 0.05,
                0.01, 0.06, 0.03), nrow=3, byrow=TRUE)
  n <- p * N
  result <- var_kappa(n)

  expect_true(abs(result$var_kappa - 0.002885) <= 0.0000005,
              info=paste("var", 0.002885, result$var_kappa))

  expect_true(abs(result$var_kappa0 - 0.003082) <= 0.0000005,
              info=paste("var2", 0.003082, result$var_kappa2))
}
)
