% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registers.R
\name{registers}
\alias{registers}
\title{Register variables (with descriptions) required for the osdc algorithm.}
\source{
Many of the details within the \code{\link[=registers]{registers()}} metadata come
from the full official list of registers from Statistics Denmark (DST):
\url{https://www.dst.dk/extranet/forskningvariabellister/Oversigt\%20over\%20registre.html}
}
\usage{
registers()
}
\value{
Outputs a list of registers and variables required by osdc. Each
list item contains the official Danish name of the register, the start
year, the end year, and the variables with their descriptions. The
variables item is a data frame with 4 columns:

\describe{
\item{name}{The official name of the variable found in the register.}
\item{danish_description}{The official Danish description of the variable.}
\item{english_description}{The translated English description of the variable.}
\item{data_type}{The data type, e.g. "character" of the variable. Could have multiple options (e.g. "Date" or "character").}
}
}
\description{
Register variables (with descriptions) required for the osdc algorithm.
}
\examples{
registers()
}
