% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_miscellaneous.R
\name{osm_bbox_objects}
\alias{osm_bbox_objects}
\title{Retrieve map data by bounding box}
\usage{
osm_bbox_objects(bbox, format = c("R", "xml", "json"), tags_in_columns = FALSE)
}
\arguments{
\item{bbox}{Coordinates for the area to retrieve the map data from (\verb{left,bottom,right,top}). It can be specified by
a character, matrix, vector, \code{bbox} object from \pkg{sf}, a \code{SpatExtent} from \pkg{terra}. Unnamed vectors and
matrices will be sorted appropriately and must merely be in the order (\code{x}, \code{y}, \code{x}, \code{y}) or \code{x} in the first
column and \code{y} in the second column.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}.}

\item{tags_in_columns}{If \code{FALSE} (default), the tags of the objects are saved in a single list column \code{tags}
containing a \code{data.frame} for each OSM object with the keys and values. If \code{TRUE}, add a column for each key.
Ignored if \code{format != "R"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one OSM object per row. If \code{format = "xml"}, returns a
\link[xml2:oldclass]{xml2::xml_document} following the
\href{https://wiki.openstreetmap.org/wiki/OSM_XML#OSM_XML_file_format_notes}{OSM_XML format}. If \code{format = "json"},
returns a list with a json structure following the \href{https://wiki.openstreetmap.org/wiki/OSM_JSON}{OSM_JSON format}.
}
\description{
The following command returns:
\itemize{
\item All nodes that are inside a given bounding box and any relations that reference them.
\item All ways that reference at least one node that is inside a given bounding box, any relations that reference them
[the ways], and any nodes outside the bounding box that the ways may reference.
\item All relations that reference one of the nodes, ways or relations included due to the above rules. (Does '''not'''
apply recursively, see explanation below.)
}
}
\details{
Note that, while this command returns those relations that reference the aforementioned nodes and ways, the reverse
is not true: it does not (necessarily) return all of the nodes and ways that are referenced by these relations. This
prevents unreasonably-large result sets. For example, imagine the case where:
\itemize{
\item There is a relation named "England" that references every node in England.
\item The nodes, ways, and relations are retrieved for a bounding box that covers a small portion of England.
While the result would include the nodes, ways, and relations as specified by the rules for the command, including
the "England" relation, it would (fortuitously) \strong{not} include \strong{every} node and way in England. If desired, the
nodes and ways referenced by the "England" relation could be retrieved by their respective IDs.
}

Also note that ways which intersect the bounding box but have no nodes within the bounding box will not be returned.
}
\note{
For downloading data for purposes other than editing or exploring the history of the objects, perhaps is better to
use the Overpass API. A similar function to download OSM objects using Overpass, is implemented in the
\pkg{osmdata} function \code{opq()}.
}
\examples{
map_data <- osm_bbox_objects(bbox = c(1.8366775, 41.8336843, 1.8379971, 41.8344537))
## bbox as a character value also works (bbox = "1.8366775,41.8336843,1.8379971,41.8344537").
map_data
}
\seealso{
Other get OSM objects' functions: 
\code{\link{osm_get_objects}()},
\code{\link{osm_history_object}()},
\code{\link{osm_relations_object}()},
\code{\link{osm_ways_node}()},
\code{\link{osmapi_objects}()}
}
\concept{get OSM objects' functions}
