% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_stop_server.R
\name{osrm_servers}
\alias{osrm_servers}
\title{List OSRM servers started via this package}
\usage{
osrm_servers()
}
\value{
A data.frame with columns:
\code{id}, \code{pid}, \code{port}, \code{algorithm}, \code{started_at}, \code{alive}, \code{has_handle}, \code{log}.
}
\description{
Returns a snapshot of servers registered by \code{\link[=osrm_start_server]{osrm_start_server()}} or \code{\link[=osrm_start]{osrm_start()}}.
You can stop one by passing its \code{id}, \code{port}, or \code{pid} to \code{\link[=osrm_stop]{osrm_stop()}}.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # copy example OSM PBF into a temporary workspace to avoid polluting pkg data
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)
  graph <- osrm_prepare_graph(tmp_pbf, overwrite = TRUE, threads = 1L)

  srv <- osrm_start_server(graph$osrm_job_artifact, port = 6000, threads = 1L)
  osrm_servers()
  osrm_stop(srv)

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}
}
