# Contributing

## Introduction

Welcome, and thank you for your interest in contributing to the OpenTelemetry Protocol (OTLP) Specification! Your contributions — big or small — are invaluable in shaping and improving this essential part of the OpenTelemetry ecosystem.

Whether you are fixing a small issue, updating documentation, or introducing a major improvement, we appreciate your efforts.
If you're new to the project, don't hesitate to ask questions and seek guidance from the community.
We are here to support you!

Before contributing, we encourage you to read the OpenTelemetry project [contributing
guide](https://github.com/open-telemetry/community/blob/main/guides/contributor/README.md)
for general information about the project.

## Prerequisites

- `Docker`

## Making changes to the .proto files

After making any changes to .proto files make sure to generate all
implementation by running `make gen-all`.

## Further Help

If you have any questions or need assistance while contributing, feel free to reach out to the [`#otel-specification`](https://cloud-native.slack.com/archives/C01N7PP1THC) Slack channel.  
View meeting notes of previous SIG calls in this [google doc](https://docs.google.com/spreadsheets/d/1SYKfjYhZdm2Wh2Cl6KVQalKg_m4NhTPZqq-8SzEVO6s/edit?gid=0#gid=0) as stated [here](https://github.com/open-telemetry/community/?tab=readme-ov-file#governing-bodies) to stay up to date.

Also see the [specification](https://github.com/open-telemetry/opentelemetry-specification?tab=readme-ov-file#questions) repo for more info. Thank you.
