% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsing_functions.R
\name{R_Simulate}
\alias{R_Simulate}
\title{Returns the Oxcal code for the simulation of 14C dates}
\usage{
R_Simulate(c_dates, stds, names = seq_along(c_dates))
}
\arguments{
\item{c_dates}{a vector containing the calendar dates that should be simulated}

\item{stds}{a vector containing the standard deviation that should be simulated (length 1 or same length as c_dates)}

\item{names}{a vector of names for the resulting simulated dates}
}
\value{
a string containing the respective Oxcal code
}
\description{
R_Simulate takes names, calendar dates and standard deviation for those dates as vectors, and returns
a bit of oxcal code that can be used to feed it into oxcal.
For details concerning the Oxcal simulation please consult the help page of Oxcal.
}
