% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_costeffectiveness.R
\name{calculate_ceac_mult}
\alias{calculate_ceac_mult}
\title{Calculate cost-effectiveness probabilities.}
\usage{
calculate_ceac_mult(
  df,
  outcomes,
  costs,
  v_wtp = seq(from = 0, to = 1e+05, by = 1000)
)
}
\arguments{
\item{df}{a dataframe.}

\item{outcomes}{character. Vector of variable names containing the outcomes to be plotted on the x-axis. The variable names should be structured as follows: 't_qaly_d_' followed by the name of the strategy: e.g. 't_qaly_d_intervention'.}

\item{costs}{character. Vector of variable names containing the costs to be plotted on the y-axis. The variable names should be structured as follows: 't_costs_d_' followed by the name of the strategy: e.g. 't_costs_d_intervention'.}

\item{v_wtp}{vector of numerical values. Vector of willingness-to-pay threshold for which the probabilities of cost effectiveness have to be defined. Default is 0:100,000 by increments of 1,000.}
}
\value{
A dataframe with three columns:
\itemize{
   \item WTP_threshold = The willingness-to-pay thresholds at which the probability of cost effectiveness has been calculated for both strategies
   \item Prob_int = The probability that the intervention strategy is cost effective at a given willingness-to-pay threshold
   \item Prob_comp = The probability that the comparator strategy is cost effective at a given willingness-to-pay threshold
   }
}
\description{
This function calculates the probabilities that each strategy is the cost effective at different willingness to pay thresholds, for an infinite amount of strategies.
}
\examples{
# Calculate probabilities of cost effectiveness using the example dataframe,
data("df_pa")
df_pa$t_qaly_d_int2 <- df_pa$t_qaly_d_int * 1.5 # creating additional outcome variable
df_pa$t_costs_d_int2 <- df_pa$t_costs_d_int * 1.5 # creating additional cost variable
calculate_ceac_mult(df = df_pa,
             outcomes = c("t_qaly_d_int", "t_qaly_d_comp", "t_qaly_d_int2"),
             costs = c("t_costs_d_int","t_costs_d_comp", "t_costs_d_int2")
             )
}
