% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{check_positive}
\alias{check_positive}
\title{Check whether variables are strictly positive}
\usage{
check_positive(..., df, max_view = 50)
}
\arguments{
\item{...}{character vector. This character vector contains the name of the variables of which the sum will be checked.}

\item{df}{a dataframe.}

\item{max_view}{numeric. Determines the number of iterations to display which do not fulfill the check. Default is 50.}
}
\value{
A dataframe.
}
\description{
This function tests whether variables are strictly positive (for instance for costs and relative risks inputs)
}
\examples{
# Checking whether a variable is strictly positive
check_positive("c_pfs", df = df_pa)

# Checking whether two variables are strictly positive
# Descreasing the number of iterations to display to 20.
check_positive("c_pfs", "c_pd", df = df_pa)
}
