% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_hemodel.R
\name{perform_dowsa}
\alias{perform_dowsa}
\title{Perform deterministic one-way sensitivity analyses using probabilistic inputs and outputs.}
\usage{
perform_dowsa(df, vars, wtp = 120000)
}
\arguments{
\item{df}{a dataframe. This dataframe contains the probabilistic inputs and outputs of the health economic model.}

\item{vars}{a vector of strings. Contains the name of the variables for which to perform the deterministic one-way sensitivity analysis.}

\item{wtp}{numeric. The willingness to pay per QALY in euros. Default is 120,000 euros per QALY.}
}
\value{
A dataframe. The outcome of the deterministic one-way sensitivity analyses is the iNMB by default.
}
\description{
This function performs the deterministic one-way sensitivity analyses (DOWSA) using probabilistic inputs and outputs for the health economic model developed to test the package. The outcome of the DOWSA is the incremental net monetary benefit.
}
\examples{
# Perform the deterministic one-way sensitivity analyses for a selection of parameters
\donttest{
data(df_pa)
df_res_dowsa <- perform_dowsa(df = df_pa,
                              vars = c("rr", "c_pfs"))
                              }
}
