% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_openai.R
\name{build_openai_batch_requests}
\alias{build_openai_batch_requests}
\title{Build OpenAI batch JSONL lines for paired comparisons}
\usage{
build_openai_batch_requests(
  pairs,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  endpoint = c("chat.completions", "responses"),
  temperature = NULL,
  top_p = NULL,
  logprobs = NULL,
  reasoning = NULL,
  include_thoughts = FALSE,
  request_id_prefix = "EXP"
)
}
\arguments{
\item{pairs}{A data frame or tibble with columns \code{ID1}, \code{text1},
\code{ID2}, and \code{text2}.}

\item{model}{Character scalar giving the OpenAI model name.
Supports standard names (e.g. \code{"gpt-4.1"}) and date-stamped versions
(e.g. \code{"gpt-5.2-2025-12-11"}).}

\item{trait_name}{Short label for the trait (e.g., "Overall Quality").}

\item{trait_description}{Full-text definition of the trait.}

\item{prompt_template}{Character template containing the placeholders
\code{{TRAIT_NAME}}, \code{{TRAIT_DESCRIPTION}}, \code{{SAMPLE_1}},
and \code{{SAMPLE_2}}. Defaults to \code{set_prompt_template()}.}

\item{endpoint}{Which OpenAI endpoint to target. One of
\code{"chat.completions"} (default) or \code{"responses"}.}

\item{temperature}{Optional temperature parameter. Defaults to \code{0} for
standard models (deterministic). Must be \code{NULL} for reasoning models
(enabled).}

\item{top_p}{Optional top_p parameter.}

\item{logprobs}{Optional logprobs parameter.}

\item{reasoning}{Optional reasoning effort for \code{gpt-5.1/5.2} when using
the \code{/v1/responses} endpoint. Typically \code{"none"}, \code{"low"},
\code{"medium"}, or \code{"high"}.}

\item{include_thoughts}{Logical; if TRUE and using \code{responses} endpoint
with reasoning, requests a summary. Defaults \code{reasoning} to \code{"low"}
for gpt-5.1/5.2 if not specified.}

\item{request_id_prefix}{String prefix for \code{custom_id}; the full
ID takes the form \code{"<prefix>_<ID1>_vs_<ID2>"}.}
}
\value{
A tibble with one row per pair and columns:
\itemize{
\item \code{custom_id}: ID string used by the batch API.
\item \code{method}: HTTP method (\code{"POST"}).
\item \code{url}: Endpoint path (\code{"/v1/chat/completions"} or
\code{"/v1/responses"}).
\item \code{body}: List column containing the request body.
}
}
\description{
This helper constructs one JSON object per pair of writing samples,
suitable for use with the OpenAI batch API. It supports both
\code{/v1/chat/completions} and \code{/v1/responses} endpoints.
}
\examples{
\dontrun{
# Requires OPENAI_API_KEY and network access.
library(pairwiseLLM)

data("example_writing_samples", package = "pairwiseLLM")

pairs <- example_writing_samples |>
  make_pairs() |>
  sample_pairs(n_pairs = 3, seed = 123) |>
  randomize_pair_order(seed = 456)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

# 1. Basic chat.completions batch with no thoughts
batch_tbl_chat <- build_openai_batch_requests(
  pairs             = pairs,
  model             = "gpt-4.1",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  endpoint          = "chat.completions",
  temperature       = 0
)

# 2. GPT-5.2-2025-12-11 Responses Batch with Reasoning
batch_resp <- build_openai_batch_requests(
  pairs = pairs,
  model = "gpt-5.2-2025-12-11",
  trait_name = td$name,
  trait_description = td$description,
  prompt_template = tmpl,
  endpoint = "responses",
  include_thoughts = TRUE, # implies reasoning="low" if not set
  reasoning = "medium"
)
batch_tbl_chat
batch_tbl_resp
}

}
