% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_batch_api.R
\name{gemini_get_batch}
\alias{gemini_get_batch}
\title{Retrieve a Gemini Batch job by name}
\usage{
gemini_get_batch(
  batch_name,
  api_key = Sys.getenv("GEMINI_API_KEY"),
  api_version = "v1beta"
)
}
\arguments{
\item{batch_name}{Character scalar giving the batch name.}

\item{api_key}{Optional Gemini API key. Defaults to
\code{Sys.getenv("GEMINI_API_KEY")}.}

\item{api_version}{API version string for the path; defaults to
\code{"v1beta"}.}
}
\value{
A list representing the Batch job object.
}
\description{
This retrieves the latest state of a Batch job using its \code{name} as
returned by \code{\link{gemini_create_batch}}.
}
\details{
It corresponds to a GET request on \code{/v1beta/<BATCH_NAME>}, where
\code{BATCH_NAME} is a string such as \code{"batches/123456"}.
}
\examples{
# Offline: basic batch name validation / object you would pass
batch_name <- "batches/123456"

# Online: retrieve the batch state from Gemini (requires API key + network)
\dontrun{
batch <- gemini_get_batch(batch_name = batch_name)
batch$name
batch$metadata$state
}

}
