% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_batch_api.R
\name{openai_create_batch}
\alias{openai_create_batch}
\title{Create an OpenAI batch from an uploaded file}
\usage{
openai_create_batch(
  input_file_id,
  endpoint,
  completion_window = "24h",
  metadata = NULL,
  api_key = NULL
)
}
\arguments{
\item{input_file_id}{The ID of the uploaded file (with purpose \code{"batch"}).}

\item{endpoint}{The endpoint for the batch, e.g. \code{"/v1/chat/completions"} or
\code{"/v1/responses"}.}

\item{completion_window}{Time frame in which the batch should be processed.
Currently only \code{"24h"} is supported by the API.}

\item{metadata}{Optional named list of metadata key–value pairs.}

\item{api_key}{Optional OpenAI API key.}
}
\value{
A list representing the Batch object.
}
\description{
Creates and executes a batch based on a previously uploaded input file.
}
\examples{
\dontrun{
# Requires OPENAI_API_KEY set in your environment and network access.

file_obj <- openai_upload_batch_file("batch_input.jsonl")

batch_obj <- openai_create_batch(
  input_file_id = file_obj$id,
  endpoint      = "/v1/chat/completions"
)

batch_obj$status
}

}
