% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.SepRel.R
\name{pairwise.SepRel}
\alias{pairwise.SepRel}
\title{Person Separation Reliability}
\usage{
pairwise.SepRel(pers_obj, na.rm = TRUE)
}
\arguments{
\item{pers_obj}{an object of class \code{"pers"} as a result from function \code{\link{pers}}.}

\item{na.rm}{a logical evaluating to TRUE or FALSE indicating whether NA values should be stripped before the computation proceeds.}
}
\value{
An object of class \code{c("pairwiseSepRel","list")}.
}
\description{
This function calculates an Index of Person Separation, that is the proportion of person variance that is not due to error.
}
\details{
none
}
\examples{
######################
########
data(bfiN) # loading reponse data
pers_obj <- pers(pair(bfiN))
result <- pairwise.SepRel(pers_obj)
result
str(result) # to see whats in ;-)
#### 
}
\references{
Andrich, D. (1982). An index of person separation in latent trait theory, the traditional KR.20 index, and the Guttman scale response pattern. \emph{Education Research and Perspectives, 9}(1), 95–104.
}
\keyword{fit}
\keyword{person}
