% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_panel.R
\name{balance_panel}
\alias{balance_panel}
\title{Balance panel data by filling gaps}
\usage{
balance_panel(data, ...)
}
\arguments{
\item{data}{A \code{panel_data} frame.}

\item{...}{Optional fill values specified as \code{column = value}. Any columns
not specified will be filled with \code{NA}.}
}
\value{
A \code{panel_data} frame with all entity-wave combinations present.
}
\description{
This function makes implicit missing values explicit by adding rows
with NA values for entity-wave combinations that are not present
in the data.
}
\details{
Panel data often has implicit gaps where certain entities are not
observed in certain waves. This function makes these gaps explicit
by adding rows filled with NA values (or custom values if specified).

This is the inverse operation of removing incomplete cases. It can be
useful for:
\itemize{
\item Visualizing the pattern of missing data
\item Using functions that require complete (balanced) panels
\item Explicit handling of missing waves in models
}
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)

# Create data with gaps
wages_gaps <- wages[!(wages$t == 3 & wages$id == wages$id[1]), ]
nrow(wages_gaps)  # Missing one row

# Balance the panel (add NA row)
wages_balanced <- balance_panel(wages_gaps)
nrow(wages_balanced)  # Back to full size

# Balance with custom fill values
wages_balanced <- balance_panel(wages_gaps, wks = 0, union = 0)

}
\seealso{
\code{\link[=has_gaps]{has_gaps()}}, \code{\link[=scan_gaps]{scan_gaps()}}, \code{\link[=complete_data]{complete_data()}}
}
