% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_panel.R
\name{scan_gaps}
\alias{scan_gaps}
\title{Scan for gaps in panel data}
\usage{
scan_gaps(data)
}
\arguments{
\item{data}{A \code{panel_data} frame.}
}
\value{
A tibble with columns for the id variable and wave variable,
showing which combinations are missing. If there are no gaps,
returns a tibble with zero rows.
}
\description{
This function identifies which entity-wave combinations are missing
in a \code{\link[=panel_data]{panel_data()}} object.
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)

# Create data with gaps
wages_gaps <- wages[!(wages$t == 3 & wages$id == wages$id[1]), ]
scan_gaps(wages_gaps)

}
\seealso{
\code{\link[=has_gaps]{has_gaps()}}, \code{\link[=balance_panel]{balance_panel()}}
}
