% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meandist.R
\name{pdDist}
\alias{pdDist}
\title{Compute distance between two HPD matrices}
\usage{
pdDist(A, B, metric = "Riemannian")
}
\arguments{
\item{A, B}{Hermitian positive definite matrices (of equal dimension).}

\item{metric}{the distance measure, one of \code{'Riemannian'},
\code{'logEuclidean'}, \code{'Cholesky'}, \code{'Euclidean'}, \code{'rootEuclidean'} or \code{'Procrustes'}.
Defaults to \code{'Riemannian'}.}
}
\description{
\code{pdDist} calculates a distance between two Hermitian PD matrices.
}
\details{
Available distance measures between two HPD matrices are: (i) the affine-invariant Riemannian distance (default) as in
e.g., \insertCite{B09}{pdSpecEst}[Chapter 6] or \insertCite{PFA05}{pdSpecEst}; (ii) the Log-Euclidean distance,
the Euclidean distance between matrix logarithms; (iii) the Cholesky distance, the Euclidean distance between Cholesky decompositions;
(iv) the Euclidean distance; (v) the root-Euclidean distance; and (vi) the Procrustes distance as in \insertCite{D09}{pdSpecEst}.
In particular, \code{pdDist} generalizes the function \code{shapes::distcov}, to compute the distance between two symmetric positive
definite matrices, in order to compute the distance between two Hermitian positive definite matrices.
}
\examples{
 a <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 A <- t(Conj(a)) \%*\% a
 b <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 B <- t(Conj(b)) \%*\% b
 pdDist(A, B) ## Riemannian distance

}
\references{
\insertAllCited{}
}
