% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_ecoregions.R
\name{pm_ecoregion_summary}
\alias{pm_ecoregion_summary}
\title{Summary of species richness by ecoregion}
\usage{
pm_ecoregion_summary(sort_by = c("code", "species", "endemic", "label"))
}
\arguments{
\item{sort_by}{Character string indicating how to sort the results.
Options are:
\itemize{
\item \code{"code"} (default) – sort alphabetically by ecoregion code.
\item \code{"species"} – sort by number of species (descending).
\item \code{"endemic"} – sort by number of endemic species (descending).
\item \code{"label"} – sort alphabetically by ecoregion label.
}}
}
\value{
A tibble with one row per ecoregion and the following columns:
\itemize{
\item \code{ecoregion_code} – ecoregion abbreviation.
\item \code{ecoregion_label} – ecoregion description in Spanish.
\item \code{n_species} – total number of species recorded in the ecoregion.
\item \code{n_endemic} – number of endemic species recorded in the ecoregion.
\item \code{pct_endemic} – percentage of endemic species in the ecoregion.
}
}
\description{
Computes a summary of species richness and endemism for each ecoregion
in the Peruvian mammal backbone.
}
\details{
The summary is based on the long-format table
\code{\link{peru_mammals_ecoregions}} and joins metadata from
\code{\link{peru_mammals_ecoregions_meta}} and endemism information
from \code{\link{peru_mammals}}.
}
\examples{
# Get summary for all ecoregions (sorted by code)
pm_ecoregion_summary()

# Sort by species richness
pm_ecoregion_summary(sort_by = "species")

# Sort by number of endemic species
pm_ecoregion_summary(sort_by = "endemic")

# Find ecoregion with highest species richness
eco_summary <- pm_ecoregion_summary(sort_by = "species")
eco_summary[1, ]

# Ecoregions with more than 100 species
eco_summary <- pm_ecoregion_summary()
subset(eco_summary, n_species > 100)

# Compare richness between lowland and highland ecoregions
eco_summary <- pm_ecoregion_summary(sort_by = "species")
lowland <- eco_summary[eco_summary$ecoregion_code \%in\% c("SB", "SP"), ]
highland <- eco_summary[eco_summary$ecoregion_code \%in\% c("PUN", "PAR"), ]

}
\seealso{
\code{\link{pm_list_ecoregions}()} for ecoregion metadata,
\code{\link{pm_by_ecoregion}()} to list species by ecoregion.
}
