% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPCP_glm.R
\name{OPCP_glm}
\alias{OPCP_glm}
\title{Calculate Observed Proportion of Concordant Pairs (OPCP)}
\usage{
OPCP_glm(formula, data)
}
\arguments{
\item{formula}{A formula specifying the dependent and independent variables.}

\item{data}{A data frame containing the variables specified in the formula.}
}
\value{
A numeric value representing the OPCP.
}
\description{
This function calculates the Observed Proportion of Concordant Pairs (OPCP) using Kendall's Tau as a measure of association. The pervasive functions also provide the OPCP.
}
\examples{
#Example using the spi dataset from the psychTools package
sc <- psych::scoreVeryFast(psychTools::spi.keys, psychTools::spi)
spi_sc <- cbind(psychTools::spi, sc)
spi_sc_vars <- spi_sc |>
  dplyr::select(sex, Agree, Consc, Neuro, Extra, Open)
  spi_sc_vars$sex = spi_sc_vars$sex -1

formula <- sex ~ Agree + Consc + Neuro + Extra + Open
OPCP_glm(formula = formula, data = spi_sc_vars)

}
