utils::globalVariables(
  c(
    ".",
    ":=",
    "division_title",
    "divisiondesc",
    "groupdesc",
    "classdesc",
    "subclass",
    "subclass_title",
    "subclassdesc",
    "itemdesc",
    "subitem",
    "subitemdesc",
    "sub_item",
    "variable",
    "sub_item_description",
    "divisioncode",
    "division_desc",
    "groupcode",
    "classcode",
    "subclasscode",
    "itemcode",
    "item_code",
    "item_title",
    "section",
    "chapter",
    "heading",
    "area_code",
    "id",
    "division",
    "class_code",
    "title",
    "sub_class_code",
    "majorcode",
    "submajorcode",
    "minorcode",
    "unitcode",
    "title",
    "description",
    "code_unit",
    "area_name",
    "bgy",
    "broadfield",
    "city_class",
    "code",
    "commodity",
    "commodity_description",
    "commodity_heading_desc",
    "commoditydesc",
    "correspondence_code",
    "detailedfield",
    "detailedfield_title",
    "detailedfielddesc",
    "income_classification",
    "island_region",
    "level",
    "mun",
    "narrowfield",
    "old_name",
    "parent_heading_desc",
    "population",
    "population_data",
    "prv",
    "psgc_code",
    "reg",
    "sectioncode",
    "sectiondesc",
    "status",
    "sub_class_title",
    "urban_rural",
    "geographic_level",
    "income_class",
    "year",
    "value",
    "label",
    "broadfield_title",
    "broadfielddesc",
    "class_title",
    "cols",
    "group",
    "group_title",
    "item",
    "level_title",
    "major_title",
    "majordesc",
    "minor_desc",
    "minor_title",
    "name",
    "narrowfield_title",
    "narrowfielddesc",
    "section_title",
    "submajor_title",
    "submajordesc",
    "unit_title",
    "unitdesc"
  )
)


.onLoad <- function(libname, pkgname) {
  op <- options()
  op.phscs <- list(
    phscs.options = list(
      classification_base_uri = "https://classification.psa.gov.ph",
      versions = list(
        psgc = c("Q3_2025", "July_2025", "Q2_2025", "Q1_2025", "April_2024", "Q4_2024", "Q3_2024", "Q2_2024", "Q4_2023", "Q1_2023", "Q2_2021"),
        pcoicop = c("2020", "2009"),
        pcpc = "2002",
        pscc = "2022",
        psccs = "2018",
        psced = "2017",
        psic = "2019",
        psoc = "2012"
      ),
      levels = list(
        psgc = c(
          "all",
          "regions",
          "provinces",
          "hucs",
          "cities",
          "municipalities",
          "sub_municipalities",
          "barangays",
          "income_classification",
          "urban_rural",
          "city_class"
        ),
        pcoicop = c("all", "divisions", "groups", "class", "sub-class", "item", "subitem"),
        pcpc = c("all", "sections", "divisions", "groups", "classes", "sub-classes", "item"),
        pscc = c("sections", "chapters", "headings", "commodity"),
        psccs = c("all", "section", "divisions", "groups", "classes", "sub-classes"),
        psced = c("all", "levels", "broadfield", "narrowfield", "detailedfield"),
        psic = c("all", "sections", "divisions", "groups", "classes", "sub-classes"),
        psoc = c("all", "major", "sub-major", "minor", "unit")
      )
    )
  )

  to_set <- !(names(op.phscs) %in% names(op))
  if (any(to_set)) options(op.phscs[to_set])

  invisible()
}
