% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_ordinate.R
\name{ps_ordinate}
\alias{ps_ordinate}
\title{Community phylogenetic ordination}
\usage{
ps_ordinate(ps, method = c("cmds", "nmds", "pca"), k = 3, spatial = TRUE)
}
\arguments{
\item{ps}{A \code{phylospatial} object. Unless \code{method = "pca"}, \code{ps} must have a non-null \code{dissim} component,
generated by \link{ps_add_dissim}.}

\item{method}{Ordination method, either \code{"cmds"} (the default, classical MDS, implemented via \code{stats::cmdscale()},
\code{"nmds"} (nonmetric MDS, implemented via \code{vegan::metaMDS()}; this is slower but often preferred), or \code{"pca"}
(principal component analysis, implemented via \code{stats::prcomp()}),.}

\item{k}{Positive integer giving the desired number of output dimensions; default is \code{3}.}

\item{spatial}{Logical indicating whether a spatial object (inherited from \code{ps}) should be returned.
Default is TRUE.}
}
\value{
A matrix or spatial object with \code{k} variables.
}
\description{
Perform an ordination that reduces a spatial phylogenetic data set into \code{k} dimensions, using one of
several alternative ordination algorithms.
}
\examples{
ps <- ps_add_dissim(ps_simulate(50, 5, 5))
ord <- ps_ordinate(ps, method = "cmds", k = 4)
terra::plot(ord)

}
\seealso{
For visualization using ordination onto RGB color space, see \code{\link[=ps_rgb]{ps_rgb()}}.
}
