% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_quantize.R
\name{ps_quantize}
\alias{ps_quantize}
\title{Stratified randomization of a phylospatial object}
\usage{
ps_quantize(ps, ...)
}
\arguments{
\item{ps}{Object of class \code{phylospatial}}

\item{...}{Additional arguments passed to \link[nullcat]{quantize}.}
}
\value{
A rendomized version of \code{ps}
}
\description{
Generates a randomized version of a phylospatial object by extracting the
tip community matrix, permuting it using \code{nullcat::quantize()}, and rebuilding
the phylospatial object using the permuted tip matrix.
}
\details{
The nullcat \link[nullcat]{quantize} routine involves three steps: converting a
quantitative matrix to categorical strata, permuting the resulting categorical
matrix using one of several categorical null model algorithms, and mapping the
randomized categories back to quantitative values. Supply arguments via \code{...}
to control options for each of these stages.

For repeated randomizations to generate a null distribution, it is more efficient
to use \code{ps_rand(fun = "quantize")}, which is structured to avoid unnecessarily
recomputing overhead that is shared across randomizations.
}
\examples{
\donttest{
if (requireNamespace("nullcat", quietly = TRUE)) {
  ps <- ps_simulate(data_type = "prob")
  ps_rand <- ps_quantize(ps, n_strata = 4,
    n_iter = 1000, # note: you'd want higher n_iter for a real analysis
    method = "curvecat", fixed = "cell")
}
}
}
