% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNLS_MF.R
\name{NNLS_MF}
\alias{NNLS_MF}
\title{Performs the non-negative matrix factorisation for given phytoplankton
pigments and pigment ratios, to attain an estimate of phytoplankton
class abundances.}
\usage{
NNLS_MF(Fn, S, S_weights = NULL)
}
\arguments{
\item{Fn}{Pigment to Chl a matrix}

\item{S}{Sample data matrix – a matrix of pigment samples}

\item{S_weights}{Weights for each column}
}
\value{
A list containing
\enumerate{
\item The F matrix (pigment: Chl \emph{a}) ratios
\item The root mean square error (RMSE)
\item The C matrix (class abundances for each group)
}
}
\description{
Performs the non-negative matrix factorisation for given phytoplankton
pigments and pigment ratios, to attain an estimate of phytoplankton
class abundances.
}
\examples{
 Fmat <- as.matrix(phytoclass::Fm)
 S <- as.matrix(phytoclass::Sm)
 S_weights <- as.numeric(phytoclass:::Bounded_weights(S))
 place <- which(Fmat[, seq(ncol(Fmat) - 2)] > 0)
 num.loops <- 2
 # Run Steepest_Descent
 result <- phytoclass:::Steepest_Descent(Fmat, place, S, S_weights, num.loops)

}
