% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_keys.R
\name{get_pix_keys_by_type}
\alias{get_pix_keys_by_type}
\title{Get PIX Keys by Key Type}
\usage{
get_pix_keys_by_type(date, verbose = TRUE)
}
\arguments{
\item{date}{Character string in "YYYY-MM-DD" format specifying the reference
date. This parameter is \strong{required}. The API returns data for the last
day of the specified month.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with summary data by key type.
}
\description{
Retrieves PIX keys data and returns a summary by key type.
}
\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get summary by key type
get_pix_keys_by_type(date = "2025-12-01")
}
}
