% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_transactions_municipality.R
\name{get_pix_transactions_by_state}
\alias{get_pix_transactions_by_state}
\title{Get PIX Transactions by State}
\usage{
get_pix_transactions_by_state(database, verbose = TRUE)
}
\arguments{
\item{database}{Character string in "YYYYMM" format specifying which month's
data to retrieve. This parameter is \strong{required}.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with PIX transaction data aggregated by state.
}
\description{
A convenience wrapper around \code{\link[=get_pix_transactions_by_municipality]{get_pix_transactions_by_municipality()}} that
aggregates data at the state level.
}
\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get state-level aggregates for December 2025
states <- get_pix_transactions_by_state(database = "202512")
}
}
