% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pix_timeout}
\alias{pix_timeout}
\title{Get or Set API Request Timeout}
\usage{
pix_timeout(seconds = NULL)
}
\arguments{
\item{seconds}{Integer; timeout in seconds. If NULL, returns the current timeout.}
}
\value{
\itemize{
\item \code{pix_timeout()}: Returns the current timeout in seconds (invisibly when setting).
\item When called with \code{seconds}, sets the timeout and returns the new value invisibly.
}
}
\description{
Get or set the timeout for API requests. The default timeout is 120 seconds.
The BCB API can be slow for large queries, so a generous timeout is recommended.
}
\examples{
# Get current timeout
pix_timeout()

# Set timeout to 180 seconds (3 minutes)
pix_timeout(180)

# Set timeout to 60 seconds
pix_timeout(60)

# Reset to default (120 seconds)
pix_timeout(120)
}
