% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alf.R
\name{loss}
\alias{loss}
\alias{alf}
\alias{l0a}
\title{Loss functions}
\usage{
alf(x, eps = 0.001)

l0a(x, eps = 0.01)
}
\arguments{
\item{x}{Numeric vector. Input values to transform.}

\item{eps}{Positive numeric scalar (default .001 for \code{alf()} and .01
for \code{l0a()}). Small regularization constant to avoid
non-differentiability and division-by-zero issues.}
}
\value{
Numeric vector of the same length as x.
}
\description{
For small eps this provides a smooth,
numerically stable approximation of |x|^(1/2) (i.e. the square root of
the absolute value). The function is vectorized over x.
}
\details{
The ALF, (x^2 + eps)^(1/4), is useful when a smooth
surrogate for sqrt(|x|) is required (for optimization or
regularization) while maintaining numerical stability near x = 0.

L0a, x^2/(x^2 + eps), is an approximation of the L0 penalty.
}
\examples{
alf(0)
alf(c(-4, -1, 0, 1, 4))
alf(0.5, eps = 1e-6)
l0a(0)
l0a(c(0, 1e-3, 0.1, 1))
l0a(c(-2, 0, 2), eps = 1e-4)
}
