% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jumble.R
\name{play_jumble}
\alias{play_jumble}
\alias{jumble}
\title{Play a game of jumbles in the console}
\source{
The default word list is derived from
\href{http://wordlist.aspell.net/12dicts/}{12dicts} created by
\href{http://www.wyrdplay.org/}{Alan Beale}.

This word list is passed through the
\href{https://www.cs.cmu.edu/~biglou/resources/}{Offensive/Profane Word List}
created by \href{https://www.cs.cmu.edu/~biglou/}{Luis Von Ahn} to filter out
potentially unwanted words.
}
\usage{
play_jumble(
  difficulty = c("beginner", "easy", "medium", "hard", "expert"),
  word_list = NULL
)
}
\arguments{
\item{difficulty}{Determines the length of words used for the game and,
if \code{word_list} is \code{NULL}, how common the words are}

\item{word_list}{Optionally, a character vector of words used to play the
game.
If unspecified, a default word list will be used based on \code{difficulty}.}
}
\value{
Generates interactive output in the console.
}
\description{
Play a game of jumbles in the console
}
\section{Difficulty}{
Difficulty levels are defined as follows:
\itemize{
\item \code{beginner}: very common English words with 3 to 5 letters
\item \code{easy}: common English words with 4 to 6 letters
\item \code{medium}: slightly less common English words with 5 to 8 letters
\item \code{hard}: somewhat less common English words with 6 to 11 letters
\item \code{expert}: less common English words with 7 to 15 letters
}
}

\section{Problematic words?}{
You can report any words you find objectionable to
\url{https://github.com/rossellhayes/hangman/issues}.

Please report:
\itemize{
\item offensive words
\item words that deal with uncomfortable topics
\item proper nouns
\item text that is not a common English word
}
}

\examples{
play_jumble()

play_jumble("beginner")
play_jumble("easy")
play_jumble("medium")
play_jumble("hard")
play_jumble("expert")

cars <- unique(gsub(" .*", "", rownames(mtcars)))
play_jumble(word_list = cars)
}
