% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field3logit.R
\name{field3logit}
\alias{field3logit}
\alias{print.field3logit}
\alias{plot.field3logit}
\alias{as_tibble.field3logit}
\alias{as.data.frame.field3logit}
\alias{fortify.field3logit}
\alias{tidy.field3logit}
\alias{coef.field3logit}
\alias{vcov.field3logit}
\alias{labels.field3logit}
\alias{labels<-.field3logit}
\title{Computation of the vector field}
\usage{
field3logit(
  model,
  delta,
  label = "",
  p0 = NULL,
  nstreams = 8,
  narrows = Inf,
  edge = 0.01,
  conf = NA,
  npoints = 100,
  alpha = deprecated(),
  vcov = deprecated()
)

\method{print}{field3logit}(x, ...)

\method{plot}{field3logit}(x, ..., add = FALSE, length = 0.05)

\method{as_tibble}{field3logit}(x, ..., wide = TRUE)

\method{as.data.frame}{field3logit}(x, ..., wide = TRUE)

\method{fortify}{field3logit}(model, data, ..., wide = TRUE)

\method{tidy}{field3logit}(x, ..., wide = TRUE)

\method{coef}{field3logit}(object, ...)

\method{vcov}{field3logit}(object, ...)

\method{labels}{field3logit}(object, ...)

\method{labels}{field3logit}(object) <- value
}
\arguments{
\item{model}{either a fitted trinomial model or a list properly structured.
See section \strong{Details} of \code{\link[=extract3logit]{extract3logit()}} and the last example of
\code{\link{plot3logit-package}}.}

\item{delta}{the change in the values of covariates to be represented.
This could be either a \code{numeric} vector, the name of a covariate
(passed either as a \code{character} or an \code{expression}), or a mathematical
expression involving one or more than one covariates (passed either as
a \code{character} or an \code{expression}). If a list is passed to \code{delta},
multiple fields are computed according to parameters passed as
components of a 2-level list. See details and examples.}

\item{label}{label to be used for identifying the field when multiple
fields are plotted. See \code{\link[=multifield3logit]{multifield3logit()}}.}

\item{p0}{\code{list} of starting points (ternary coordinates) of the curves
of the field. If not specified, \code{field3logit} automatically compute
\code{nstreams} candidate points so that arrows are evenly distributed over
the ternary plot area. See Examples.}

\item{nstreams}{number of stream lines of the field to be computed. In case
of ordinal models, this parameter is ineffective, as only one curve
can be drawn. The parameter is ineffective also if argument \code{p0} is set.}

\item{narrows}{maximum number of arrows to be drawn per stream line.}

\item{edge}{minimum distance between each arrow (or point) and
the edge of the ternary plot.}

\item{conf}{confidence level of confidence regions to be computed \strong{for each
arrow} of the vector field.}

\item{npoints}{number of points of the border to be computed \strong{for each
confidence region}.}

\item{alpha}{deprecated argument. It may be removed in a future version of
the package.}

\item{vcov}{deprecated argument. It may be removed in a future version of the
package.}

\item{x, object}{object of class \code{field3logit}.}

\item{...}{other arguments passed to or from other methods.}

\item{add}{\code{logical} argument which specifies whether the field
should be added to an existing plot (\code{add = TRUE}) or a new
ternary plot should be drawn (\code{add = FALSE}).}

\item{length}{length of the edges of the arrow head (in inches).}

\item{wide}{it allows to choose whether \code{as.data.frame}, \code{as_tibble},
\code{fortify} and \code{tidy} should return a \code{data.frame} or a \code{tibble} in wide
(default) or long form.}

\item{data}{not used. Argument included only for interface compatibility with
the generic \code{fortify}.}

\item{value}{value to be assigned.}
}
\value{
\code{S3} object of class \code{field3logit} structured as a named \code{list} or an object
of class \code{multifield3logit} if \code{delta} is a \code{list} or syntax \verb{<<...>>} is
used.
}
\description{
\code{\link[=field3logit]{field3logit()}} computes the vector field associated to a change in
regressior values (which may involve more than one regressor) of a trinomial
logit model either fitted by some multinomial regression function or
explicitly specified.

The method \code{\link[=plot]{plot()}} draws the ternary plot using standard graphics methods
provided by package \code{Ternary}. See functions \code{\link[=gg3logit]{gg3logit()}} and \code{\link[=autoplot]{autoplot()}}
for plotting through the package \code{\link[ggtern:ggtern_package]{ggtern}} based on the
grammar of graphics.

Methods \code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[=as_tibble.field3logit]{as_tibble()}},
\link[=fortify.field3logit]{fortify()} and \code{\link[=tidy]{tidy()}} permits the graphical
information of a \code{field3logit} object to be exported in a standardised format
(either a \code{data.frame} or a \code{tibble}).

See \insertCite{santi2022;textual}{plot3logit} for details and examples.
}
\details{
The content of this section is presented with plenty of details and examples
in Sections 4.1 and 4.3 of \insertCite{santi2022;textual}{plot3logit}.

Argument \code{delta} could be passed in one of the following formats:
\itemize{
\item explicitly, as a \code{numeric} vector corresponding to the change
\eqn{\Delta x\in\bm{R}^k} in regressors values \eqn{x\in\bm{R}^k};
\item implicitly, as a \code{character} of the name of the covariate to be considered.
In this case, vector \eqn{\Delta x\in\bm{R}^k} is computed for a unit
change of the specified covariate;
\item as a mathematical expression (passed as an \code{expression} or a \code{character}
object) involving one or more than one covariates. This allows one to
analyse the effects of composite covariate changes through an easy-to-write
and easy-to-read code without having to cope with explicit numerical
specification of vector \eqn{\Delta x\in\bm{R}^k}.
}

See examples for comparing all three methods.

\strong{It is also possible to pass a \code{list} to argument \code{delta}.} In such a case,
the function \code{field3logit} is run once for every component of \code{delta},
and the set of generated \code{field3logit} objects is combined into a single
object of class \code{multifield3logit}. The compoments of the list passed to
\code{delta} must be named lists whose elements are used as arguments of each call
of function \code{field3logit}, whilst the arguments specified in the parent call
of \code{field3logit} are used as default values. It follows that arguments shared
by all fields can be specified once in the parent call of \code{field3logit}, and
only arguments which changes from field to field (such as \code{delta} and
\code{label}) should be set in the lists making up the list passed to \code{delta}. See
the penultimate example in section Examples and the help of
\code{\link[=multifield3logit]{multifield3logit()}}.

\strong{Finally}, when argument \code{delta} is a character, it is possible to indicate
the name of a \code{factor} covariate between delimiters \verb{<<}, \verb{>>}. In that case,
\code{\link[=field3logit]{field3logit()}} creates a \code{multifield3logit} object where each field
corresponds to the effect of each dummy generated by the \code{factor} regressor.
If more than one regressor is included between delimiters \verb{<<}, \verb{>>}, all
combinations between dummies are generated. See the last example in section
\strong{Examples}.
}
\examples{
data(cross_1year)

\donttest{
# Fitting the model
mod0 <- nnet::multinom(employment_sit ~ finalgrade + irregularity + hsscore,
  cross_1year)
mod0

# Assessing the effect of "finalgradeHigh" (explicit notation)
field0 <- field3logit(mod0, c(0, 0, 1, 0, 0, 0))
gg3logit(field0) + stat_field3logit()

# Assessing the effect of "finalgradeHigh" (implicit notation)
field0 <- field3logit(mod0, 'finalgradeHigh')
gg3logit(field0) + stat_field3logit()

# Assessing the combined effect of "finalgradeHigh" and
# a decrease of "hsscore" by 10
field0 <- field3logit(mod0, 'finalgradeHigh - 10 * hsscore')
gg3logit(field0) + stat_field3logit()
}

# Fitting the model
mod1 <- nnet::multinom(employment_sit ~ ., data = cross_1year)

# List passed to argument "delta" for generating "multifield3logit" objects
refpoint <- list(c(0.7, 0.15, 0.15))
depo <- list(
  list(delta = 'durationShort',  label = 'Short duration'),
  list(delta = 'durationLong',   label = 'Long duration'),
  list(delta = 'finalgradeHigh', label = 'High final grade'),
  list(delta = 'finalgradeLow',  label = 'Low final grade')
)
mfields <- field3logit(mod1, delta = depo, p0 = refpoint, narrows = 1)
mfields

# Sintax "<<...>>" for categorical covariates
mfields <- field3logit(
  model = mod1, delta = '<<finalgrade>>', label = 'Final grade',
  p0 = refpoint, narrows = 1
)
mfields

}
\seealso{
\code{\link[=multifield3logit]{multifield3logit()}}, \code{\link[=gg3logit]{gg3logit()}}, \code{\link[=autoplot]{autoplot()}}.
}
