% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sankeyplot.R
\name{SankeyPlotAtomic}
\alias{SankeyPlotAtomic}
\title{Atomic Sankey plot}
\usage{
SankeyPlotAtomic(
  data,
  in_form = c("auto", "long", "lodes", "wide", "alluvia", "counts"),
  x,
  x_sep = "_",
  y = NULL,
  stratum = NULL,
  stratum_sep = "_",
  alluvium = NULL,
  alluvium_sep = "_",
  flow = FALSE,
  nodes_color = "grey30",
  links_fill_by = NULL,
  links_fill_by_sep = "_",
  links_name = NULL,
  links_color = "gray80",
  nodes_palette = "Paired",
  nodes_palcolor = NULL,
  nodes_alpha = 1,
  nodes_label = FALSE,
  nodes_width = 0.25,
  nodes_label_miny = 0,
  nodes_legend = c("auto", "separate", "merge", "none"),
  expand = c(0, 0, 0, 0),
  links_palette = "Paired",
  links_palcolor = NULL,
  links_alpha = 0.6,
  legend.box = "vertical",
  keep_empty = TRUE,
  x_text_angle = 0,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  flip = FALSE,
  theme = "theme_this",
  theme_args = list(),
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{in_form}{A character string to specify the format of the data.
Possible values are "auto", "long", "lodes", "wide", "alluvia", and "counts".}

\item{x}{A character string of the column name to plot on the x-axis.
See \code{data} for more details.}

\item{x_sep}{A character string to concatenate the columns in \code{x}, if multiple columns are provided.}

\item{y}{A character string of the column name to plot on the y-axis.
When \code{in_form} is "counts", \code{y} will be ignored. Otherwise, it defaults to the count of each \code{x}, \code{stratum}, \code{alluvium} and \code{links_fill_by}.}

\item{stratum}{A character string of the column name to group the nodes for each \code{x}.
See \code{data} for more details.}

\item{stratum_sep}{A character string to concatenate the columns in \code{stratum}, if multiple columns are provided.}

\item{alluvium}{A character string of the column name to define the links.
See \code{data} for more details.}

\item{alluvium_sep}{A character string to concatenate the columns in \code{alluvium}, if multiple columns are provided.}

\item{flow}{A logical value to use \link[ggalluvial:geom_flow]{ggalluvial::geom_flow} instead of \link[ggalluvial:geom_alluvium]{ggalluvial::geom_alluvium}.}

\item{nodes_color}{A character string to color the nodes.
Use a special value ".fill" to use the same color as the fill.}

\item{links_fill_by}{A character string of the column name to fill the links.}

\item{links_fill_by_sep}{A character string to concatenate the columns in \code{links_fill_by}, if multiple columns are provided.}

\item{links_name}{A character string to name the legend of links.}

\item{links_color}{A character string to color the borders of links.
Use a special value ".fill" to use the same color as the fill.}

\item{nodes_palette}{A character string to specify the palette of nodes fill.}

\item{nodes_palcolor}{A character vector to specify the colors of nodes fill.}

\item{nodes_alpha}{A numeric value to specify the transparency of nodes fill.}

\item{nodes_label}{A logical value to show the labels on the nodes.}

\item{nodes_width}{A numeric value to specify the width of nodes.}

\item{nodes_label_miny}{A numeric value to specify the minimum y (frequency) to show the labels.}

\item{nodes_legend}{Controls how the legend of nodes will be shown. Possible values are:
\itemize{
\item "merge": Merge the legends of nodes. That is only one legend will be shown for all nodes.
\item "separate": Show the legends of nodes separately. That is, nodes on each \code{x} will have their own legend.
\item "none": Do not show the legend of nodes.
\item "auto": Automatically determine how to show the legend.
When \code{nodes_label} is TRUE, "none" will apply.
When \code{nodes_label} is FALSE, and if stratum is the same as links_fill_by, "none" will apply.
If there is any overlapping values between the nodes on different \code{x},
"merge" will apply. Otherwise, "separate" will apply.
}}

\item{expand}{The values to expand the x and y axes. It is like CSS padding.
When a single value is provided, it is used for both axes on both sides.
When two values are provided, the first value is used for the top/bottom side and the second value is used for the left/right side.
When three values are provided, the first value is used for the top side, the second value is used for the left/right side, and the third value is used for the bottom side.
When four values are provided, the values are used for the top, right, bottom, and left sides, respectively.
You can also use a named vector to specify the values for each side.
When the axis is discrete, the values will be applied as 'add' to the 'expansion' function.
When the axis is continuous, the values will be applied as 'mult' to the 'expansion' function.
See also \url{https://ggplot2.tidyverse.org/reference/expansion.html}}

\item{links_palette}{A character string to specify the palette of links fill.}

\item{links_palcolor}{A character vector to specify the colors of links fill.}

\item{links_alpha}{A numeric value to specify the transparency of links fill.}

\item{legend.box}{A character string to specify the box of the legend, either "vertical" or "horizontal".}

\item{keep_empty}{One of FALSE, TRUE and "level". It can also take a named list to specify
different behavior for different columns. Without a named list, the behavior applies to the
categorical/character columns used on the plot, for example, the \code{x}, \code{group_by}, \code{fill_by}, etc.
\itemize{
\item{\code{FALSE} (default): Drop empty factor levels from the data before plotting.}
\item{\code{TRUE}: Keep empty factor levels and show them as a separate category in the plot.}
\item{\code{"level"}: Keep empty factor levels, but do not show them in the plot.
But they will be assigned colors from the palette to maintain consistency across multiple plots.
Alias: \code{levels}}
}}

\item{x_text_angle}{A numeric value specifying the angle of the x-axis text.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{flip}{A logical value to flip the plot.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{...}{Other arguments to pass to \link[ggalluvial:geom_alluvium]{ggalluvial::geom_alluvium} or \link[ggalluvial:geom_flow]{ggalluvial::geom_flow}.}
}
\value{
A ggplot object
}
\description{
Plot a Sankey plot without splitting the data.
}
\keyword{internal}
