% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.plsRbetanp.R
\name{coefs.plsRbetanp}
\alias{coefs.plsRbetanp}
\title{Coefficients for bootstrap computations of PLSBeta models}
\usage{
coefs.plsRbetanp(
  dataRepYtt,
  ind,
  nt,
  modele,
  family = NULL,
  method = "logistic",
  link = NULL,
  link.phi = NULL,
  type = "ML",
  verbose = TRUE,
  maxcoefvalues,
  wwetoile,
  ifbootfail
)
}
\arguments{
\item{dataRepYtt}{components' coordinates to bootstrap}

\item{ind}{indices for resampling}

\item{nt}{number of components to use}

\item{modele}{type of modele to use, see \link{plsRbeta}}

\item{family}{glm family to use, see \link{plsRbeta}}

\item{method}{method for beta regression}

\item{link}{link for beta regression}

\item{link.phi}{link.phi for beta regression}

\item{type}{type of estimates}

\item{verbose}{should info messages be displayed ?}

\item{maxcoefvalues}{maximum values allowed for the estimates of the
coefficients to discard those coming from singular bootstrap samples}

\item{wwetoile}{values of the Wstar matrix in the original fit}

\item{ifbootfail}{value to return if the estimation fails on a bootstrap
sample}
}
\value{
estimates on a bootstrap sample or \code{ifbootfail} value if the
bootstrap computation fails.
}
\description{
A function passed to \code{boot} to perform bootstrap.
}
\note{
~~some notes~~
}
\examples{
\donttest{
data("GasolineYield",package="betareg")
bootplsbeta(plsRbeta(yield~.,data=GasolineYield,nt=3, modele="pls-beta"), typeboot="fmodel_np", 
R=250, statistic=coefs.plsRbetanp)
}
}
\seealso{
See also \code{\link{bootplsbeta}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
