% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarCorr.R
\name{VarCorr.pmrm_fit}
\alias{VarCorr.pmrm_fit}
\title{Estimated covariance matrix}
\usage{
\method{VarCorr}{pmrm_fit}(x, sigma = NA, ...)
}
\arguments{
\item{x}{A fitted model object of class \code{"pmrm_fit"}.}

\item{sigma}{Not used for \code{pmrm}.}

\item{...}{Not used.}
}
\value{
A matrix \code{J} rows and \code{J} columns, where \code{J} is the number
of scheduled visits in the clinical trial.
}
\description{
Extract estimated covariance matrix among visits
within patients.
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  VarCorr(fit)
}
\seealso{
Other estimates: 
\code{\link{coef.pmrm_fit}()},
\code{\link{pmrm_marginals}()},
\code{\link{tidy.pmrm_fit}()},
\code{\link{vcov.pmrm_fit}()}
}
\concept{estimates}
