% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.pmrm_fit}
\alias{fitted.pmrm_fit}
\title{Fitted values}
\usage{
\method{fitted}{pmrm_fit}(object, data = object$data, adjust = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"pmrm_fit"}.}

\item{data}{A \code{tibble} or data frame with one row per patient visit.
This is the new data for making predictions.
It must have all the same columns as the original you fit with the model,
except that the outcome column can be entirely absent.
\code{object$data} is an example dataset that will work.
It is just like the original data, except that rows with missing
responses are removed, and the remaining rows are sorted
by patient ID and categorical scheduled visit.}

\item{adjust}{\code{TRUE} or \code{FALSE}.
\code{adjust = TRUE} returns estimates and inference for
covariate-adjusted \code{mu_ij}
values (defined in \code{vignette("models", package = "pmrm")}) for new data.
\code{adjust = FALSE} instead returns inference on \code{mu_ij - W \%*\% gamma},
the non-covariate-adjusted predictions useful in plotting a
continuous disease progression trajectory in \code{\link[=plot.pmrm_fit]{plot.pmrm_fit()}}.}

\item{...}{Not used.}
}
\value{
A numeric vector of fitted values corresponding to the
rows of the data supplied in the \code{data} argument.
}
\description{
Compute the fitted values of a fitted
progression model for repeated measures.
}
\details{
For \code{pmrm}, \code{fitted()} is much faster than \code{predict()}
for large datasets, but the output only includes the estimates
(no measures of uncertainty).
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  str(fitted(fit))
}
\seealso{
Other predictions: 
\code{\link{predict.pmrm_fit}()},
\code{\link{residuals.pmrm_fit}()}
}
\concept{predictions}
