% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.pmrm_fit}
\alias{vcov.pmrm_fit}
\title{Treatment effect parameter covariance matrix}
\usage{
\method{vcov}{pmrm_fit}(object, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"pmrm_fit"}.}

\item{...}{Not used.}
}
\value{
A matrix with covariance of each pair of \code{theta} parameters.
Rows and columns are labeled (by just study arm for proportional models,
arm and visit for non-proportional models.)
}
\description{
Extract the covariance matrix of the treatment effect
parameters of a progression model for repeated measures.
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  vcov(fit)
}
\seealso{
Other estimates: 
\code{\link{VarCorr.pmrm_fit}()},
\code{\link{coef.pmrm_fit}()},
\code{\link{pmrm_marginals}()},
\code{\link{tidy.pmrm_fit}()}
}
\concept{estimates}
