% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_data.R
\name{scan_data}
\alias{scan_data}
\title{Thoroughly scan a table to better understand it}
\usage{
scan_data(
  tbl,
  sections = "OVICMS",
  navbar = TRUE,
  width = NULL,
  lang = NULL,
  locale = NULL
)
}
\arguments{
\item{tbl}{\emph{A data table}

\verb{obj:<tbl_*>} // \strong{required}

The input table. This can be a data frame, tibble, a \code{tbl_dbi} object, or a
\code{tbl_spark} object.}

\item{sections}{\emph{Sections to include}

\verb{scalar<character>} // \emph{default:} \code{"OVICMS"}

The sections to include in the finalized \verb{Table Scan} report. A string with
key characters representing section names is required here. The default
string is \code{"OVICMS"} wherein each letter stands for the following sections
in their default order: \code{"O"}: \code{"overview"}; \code{"V"}: \code{"variables"}; \code{"I"}:
\code{"interactions"}; \code{"C"}: \code{"correlations"}; \code{"M"}: \code{"missing"}; and \code{"S"}:
\code{"sample"}. This string can be comprised of less characters and the order
can be changed to suit the desired layout of the report. For \code{tbl_dbi} and
\code{tbl_spark} objects supplied to \code{tbl}, the \code{"interactions"} and
\code{"correlations"} sections are currently excluded.}

\item{navbar}{\emph{Include navigation in HTML report}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Should there be a navigation bar anchored to the top of the report page?}

\item{width}{\emph{Width option for HTML report}

\verb{scalar<integer>} // \emph{default:} \code{NULL} (\code{optional})

An optional fixed width (in pixels) for the HTML report. By default, no
fixed width is applied.}

\item{lang}{\emph{Reporting language}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The language to use for label text in the report. By default, \code{NULL} will
create English (\code{"en"}) text. Other options include French (\code{"fr"}), German
(\code{"de"}), Italian (\code{"it"}), Spanish (\code{"es"}), Portuguese (\code{"pt"}), Turkish
(\code{"tr"}), Chinese (\code{"zh"}),  Russian (\code{"ru"}), Polish (\code{"pl"}), Danish
(\code{"da"}), Swedish (\code{"sv"}), and Dutch (\code{"nl"}).}

\item{locale}{\emph{Locale for value formatting within reports}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale ID to use for formatting values in the report according
the locale's rules. Examples include \code{"en_US"} for English (United States)
and \code{"fr_FR"} for French (France); more simply, this can be a language
identifier without a country designation, like \code{"es"} for Spanish (Spain,
same as \code{"es_ES"}).}
}
\value{
A \code{ptblank_tbl_scan} object.
}
\description{
Generate an HTML report that scours the input table data. Before calling up
an \emph{agent} to validate the data, it's a good idea to understand the data with
some level of precision. Make this the initial step of a well-balanced
\emph{data quality reporting} workflow. The reporting output contains several
sections to make everything more digestible, and these are:

\describe{
\item{Overview}{Table dimensions, duplicate row counts, column types, and
reproducibility information}
\item{Variables}{A summary for each table variable and further statistics and
summaries depending on the variable type}
\item{Interactions}{A matrix plot that shows interactions between variables}
\item{Correlations}{A set of correlation matrix plots for numerical
variables}
\item{Missing Values}{A summary figure that shows the degree of missingness
across variables}
\item{Sample}{A table that provides the head and tail rows of the dataset}
}

The resulting object can be printed to make it viewable in the RStudio
Viewer. It's also a \code{"shiny.tag.list"} object and so can be integrated in R
Markdown HTML output or in Shiny applications. If you need the output HTML,
it's to export that to a file with the \code{\link[=export_report]{export_report()}} function.
}
\section{Examples}{


Get an HTML document that describes all of the data in the \code{dplyr::storms}
dataset.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_scan <- scan_data(tbl = dplyr::storms)
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_scan_data_1.png" alt="This image was generated from the first code example in the `scan_data()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

1-1
}

\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{db_tbl}()},
\code{\link{draft_validation}()},
\code{\link{file_tbl}()},
\code{\link{tbl_get}()},
\code{\link{tbl_source}()},
\code{\link{tbl_store}()},
\code{\link{validate_rmd}()}
}
\concept{Planning and Prep}
