% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{snip_stats}
\alias{snip_stats}
\title{A \code{fn} for \code{info_snippet()}: get an inline statistical summary}
\usage{
snip_stats(column, type = c("5num", "7num", "bowley"))
}
\arguments{
\item{column}{\emph{The target column}

\verb{scalar<character>} // \strong{required}

The name of the column that contains the target values.}

\item{type}{\emph{Type of statistical summary}

\verb{singl-kw:[5num|7num|bowley]} // \emph{default:} \code{"5num"}

The type of summary. By default, the \code{"5num"} keyword is used to generate a
five-number summary. Two other options provide seven-number summaries:
\code{"7num"} and \code{"bowley"}.}
}
\value{
A formula needed for \code{\link[=info_snippet]{info_snippet()}}'s \code{fn} argument.
}
\description{
The \code{snip_stats()} function can be used as an \code{\link[=info_snippet]{info_snippet()}} function
(i.e., provided to \code{fn}) to produce a five- or seven-number statistical
summary. This inline summary works well within a paragraph of text and can
help in describing the distribution of numerical values in a column.

For a given column, three different types of inline statistical summaries can
be provided:
\enumerate{
\item a five-number summary (\code{"5num"}): minimum, Q1, median, Q3, maximum
\item a seven-number summary (\code{"7num"}): P2, P9, Q1, median, Q3, P91, P98
\item Bowley's seven-figure summary (\code{"bowley"}): minimum, P10, Q1, median, Q3,
P90, maximum
}
}
\section{Examples}{


Generate an informant object, add a snippet with \code{\link[=info_snippet]{info_snippet()}} and
\code{snip_stats()} (giving us a method to get some summary stats for column \code{d}).
Define a location for the snippet result in \code{{ }} and then \code{\link[=incorporate]{incorporate()}}
the snippet into the info text. Note here that the order of the
\code{\link[=info_columns]{info_columns()}} and \code{\link[=info_snippet]{info_snippet()}} calls doesn't matter.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <-
  create_informant(
    tbl = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\%
  info_columns(
    columns = d,
    `Stats` = "Stats (fivenum): \{stats_d\}."
  ) \%>\%
  info_snippet(
    snippet_name = "stats_d",
    fn = snip_stats(column = "d")
  ) \%>\%
  incorporate()
}\if{html}{\out{</div>}}

We can print the \code{informant} object to see the information report.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_snip_stats_1.png" alt="This image was generated from the first code example in the `snip_stats()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

3-7
}

\seealso{
Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_columns_from_tbl}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()},
\code{\link{info_tabular}()},
\code{\link{snip_highest}()},
\code{\link{snip_list}()},
\code{\link{snip_lowest}()}
}
\concept{Information Functions}
