% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpsetOf.R
\name{UpsetOf}
\alias{UpsetOf}
\title{Computing upsets.}
\usage{
UpsetOf(poset, elements)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{elements}{a vector of character strings (the names of the input elements).}
}
\value{
A vector of character strings (the names of the poset elements in the upset).
}
\description{
Computes the upset of a set of elements of the input poset.
}
\examples{
elems<- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

up <- UpsetOf(pos, c("a","c"))

}
